/*!function(t){t.fn.twentytwenty=function(e){var e=t.extend({default_offset_pct:.5,orientation:"horizontal"},e);return this.each(function(){var n=e.default_offset_pct,i=t(this),a=e.orientation,s="vertical"===a?"down":"left",d="vertical"===a?"up":"right";i.wrap("<div class='twentytwenty-wrapper twentytwenty-"+a+"'></div>"),i.append("<div class='twentytwenty-overlay'></div>");var r=i.find("img:first"),w=i.find("img:last");i.append("<div class='twentytwenty-handle'></div>");var c=i.find(".twentytwenty-handle");c.append("<span class='twentytwenty-"+s+"-arrow'></span>"),c.append("<span class='twentytwenty-"+d+"-arrow'></span>"),i.addClass("twentytwenty-container"),r.addClass("twentytwenty-before"),w.addClass("twentytwenty-after");var o=i.find(".twentytwenty-overlay");o.append("<div class='twentytwenty-before-label'></div>"),o.append("<div class='twentytwenty-after-label'></div>");var f=function(t){var e=r.width(),n=r.height();return{w:e+"px",h:n+"px",cw:t*e+"px",ch:t*n+"px"}},l=function(t){"vertical"===a?r.css("clip","rect(0,"+t.w+","+t.ch+",0)"):r.css("clip","rect(0,"+t.cw+","+t.h+",0)"),i.css("height",t.h)},v=function(t){var e=f(t);c.css("vertical"===a?"top":"left","vertical"===a?e.ch:e.cw),l(e)};t(window).on("resize.twentytwenty",function(t){v(n)});var p=0,y=0;c.on("movestart",function(t){(t.distX>t.distY&&t.distX<-t.distY||t.distX<t.distY&&t.distX>-t.distY)&&"vertical"!==a?t.preventDefault():(t.distX<t.distY&&t.distX<-t.distY||t.distX>t.distY&&t.distX>-t.distY)&&"vertical"===a&&t.preventDefault(),i.addClass("active"),p=i.offset().left,offsetY=i.offset().top,y=r.width(),imgHeight=r.height()}),c.on("moveend",function(t){i.removeClass("active")}),c.on("move",function(t){i.hasClass("active")&&(n="vertical"===a?(t.pageY-offsetY)/imgHeight:(t.pageX-p)/y,0>n&&(n=0),n>1&&(n=1),v(n))}),i.find("img").on("mousedown",function(t){t.preventDefault()}),t(window).trigger("resize.twentytwenty")})}}(jQuery);*/
//# sourceMappingURL=./jquery.twentytwenty.min.js.map

alert('twenty');

(function($) {

    $.fn.twentytwenty = function(options) {
        var options = $.extend({
            default_offset_pct: 0.5,
            orientation: 'horizontal',
            before_label: 'Before',
            after_label: 'After',
            no_overlay: false,
            move_slider_on_hover: false,
            move_with_handle_only: true,
            click_to_move: false
        }, options);

        return this.each(function() {

            var sliderPct = options.default_offset_pct;
            var container = $(this);
            var sliderOrientation = options.orientation;
            var beforeDirection = (sliderOrientation === 'vertical') ? 'down' : 'left';
            var afterDirection = (sliderOrientation === 'vertical') ? 'up' : 'right';


            container.wrap("<div class='twentytwenty-wrapper twentytwenty-" + sliderOrientation + "'></div>");
            if (!options.no_overlay) {
                container.append("<div class='twentytwenty-overlay'></div>");
                var overlay = container.find(".twentytwenty-overlay");
                overlay.append("<div class='twentytwenty-before-label' data-content='" + options.before_label + "'></div>");
                overlay.append("<div class='twentytwenty-after-label' data-content='" + options.after_label + "'></div>");
            }
            var beforeImg = container.find("img:first");
            var afterImg = container.find("img:last");
            container.append("<div class='twentytwenty-handle'></div>");
            var slider = container.find(".twentytwenty-handle");
            slider.append("<span class='twentytwenty-" + beforeDirection + "-arrow'></span>");
            slider.append("<span class='twentytwenty-" + afterDirection + "-arrow'></span>");
            container.addClass("twentytwenty-container");
            beforeImg.addClass("twentytwenty-before");
            afterImg.addClass("twentytwenty-after");

            var calcOffset = function(dimensionPct) {
                var w = beforeImg.width();
                var h = beforeImg.height();
                return {
                    w: w + "px",
                    h: h + "px",
                    cw: (dimensionPct * w) + "px",
                    ch: (dimensionPct * h) + "px"
                };
            };

            var adjustContainer = function(offset) {
                if (sliderOrientation === 'vertical') {
                    beforeImg.css("clip", "rect(0," + offset.w + "," + offset.ch + ",0)");
                    afterImg.css("clip", "rect(" + offset.ch + "," + offset.w + "," + offset.h + ",0)");
                } else {
                    beforeImg.css("clip", "rect(0," + offset.cw + "," + offset.h + ",0)");
                    afterImg.css("clip", "rect(0," + offset.w + "," + offset.h + "," + offset.cw + ")");
                }
                container.css("height", offset.h);
            };

            var adjustSlider = function(pct) {
                var offset = calcOffset(pct);
                slider.css((sliderOrientation === "vertical") ? "top" : "left", (sliderOrientation === "vertical") ? offset.ch : offset.cw);
                adjustContainer(offset);
            };

            // Return the number specified or the min/max number if it outside the range given.
            var minMaxNumber = function(num, min, max) {
                return Math.max(min, Math.min(max, num));
            };

            // Calculate the slider percentage based on the position.
            var getSliderPercentage = function(positionX, positionY) {
                var sliderPercentage = (sliderOrientation === 'vertical') ? (positionY - offsetY) / imgHeight : (positionX - offsetX) / imgWidth;

                return minMaxNumber(sliderPercentage, 0, 1);
            };


            $(window).on("resize.twentytwenty", function(e) {
                adjustSlider(sliderPct);
            });

            var offsetX = 0;
            var offsetY = 0;
            var imgWidth = 0;
            var imgHeight = 0;
            var onMoveStart = function(e) {
                if (((e.distX > e.distY && e.distX < -e.distY) || (e.distX < e.distY && e.distX > -e.distY)) && sliderOrientation !== 'vertical') {
                    e.preventDefault();
                } else if (((e.distX < e.distY && e.distX < -e.distY) || (e.distX > e.distY && e.distX > -e.distY)) && sliderOrientation === 'vertical') {
                    e.preventDefault();
                }
                container.addClass("active");
                offsetX = container.offset().left;
                offsetY = container.offset().top;
                imgWidth = beforeImg.width();
                imgHeight = beforeImg.height();
            };
            var onMove = function(e) {
                if (container.hasClass("active")) {
                    sliderPct = getSliderPercentage(e.pageX, e.pageY);
                    adjustSlider(sliderPct);
                }
            };
            var onMoveEnd = function() {
                container.removeClass("active");
            };

            var moveTarget = options.move_with_handle_only ? slider : container;
            moveTarget.on("movestart", onMoveStart);
            moveTarget.on("move", onMove);
            moveTarget.on("moveend", onMoveEnd);

            if (options.move_slider_on_hover) {
                container.on("mouseenter", onMoveStart);
                container.on("mousemove", onMove);
                container.on("mouseleave", onMoveEnd);
            }

            slider.on("touchmove", function(e) {
                e.preventDefault();
            });

            container.find("img").on("mousedown", function(event) {
                event.preventDefault();
            });

            if (options.click_to_move) {
                container.on('click', function(e) {
                    offsetX = container.offset().left;
                    offsetY = container.offset().top;
                    imgWidth = beforeImg.width();
                    imgHeight = beforeImg.height();

                    sliderPct = getSliderPercentage(e.pageX, e.pageY);
                    adjustSlider(sliderPct);
                });
            }

            $(window).trigger("resize.twentytwenty");
        });
    };

})(jQuery);